<?php

namespace App\Actions;

use DateTimeImmutable;

class HowDaysToNYAction
{
    /**
     * Функция рассчитывает кол-во дней до нового года
     * @param DateTime $date дата от которой, необходимо рассчитать кол-во дней
     * @return int
     */
    public function act(DateTimeImmutable $date): int
    {
        $dateOfNY = $date->modify('first day of Jan +1 year');

        return (int) $dateOfNY->diff($date)->format('%a');
    }
}