<?php

namespace App\Requests;

use DateTimeImmutable;
use Symfony\Component\Validator\Constraints\Date;
use Symfony\Component\Validator\Constraints\NotBlank;

class DiffDaysRequest extends BaseRequest
{
    #[Date]
    #[NotBlank]
    public $startDate;

    #[Date]
    #[NotBlank]
    public $endDate;

    /**
     * @return mixed
     */
    public function serialise(): mixed
    {
        return [
            'startDate' => new DateTimeImmutable($this->startDate),
            'endDate' => new DateTimeImmutable($this->endDate),
        ];
    }
}