<?php

namespace App\Controller;
use App\Actions\ReadLogFileAction;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

class ReadLogFileController extends AbstractController
{
    /**
     * Принимает путь до файла,
     * проверяет, что файл существует и выводит пользователю весь контент файла
     * (файл можешь создать любой)
     *
     * @param Request $request
     * @param ReadLogFileAction $action
     * @return Response
     */
    #[Route('/read', name: 'app_read_log_file', methods: ['POST'])]
    public function index(Request $request, ReadLogFileAction $action): Response
    {
        $file = $request->files->get("File");
        return new Response($action->act($file->getPathname()));
    }

    }

