<?php

namespace App\Controller;

use App\Actions\IdSearchAction;
use App\Requests\UsersRequest;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Attribute\Route;

class IdSearchController extends AbstractController
{
    /**
     * Контроллер найдет элемент с указаным id используя sortPrice
     * @param UsersRequest $request
     * @param IdSearchAction $action
     * @return JsonResponse
     */
    #[Route('/search', name: 'app_search', methods: ['POST'])]
    public function index(UsersRequest $request, IdSearchAction $action): JsonResponse
    {
        return new JsonResponse($action->act($request->serialise()));
    }
}