<?php

namespace App\Shared\Service;

class ValidateService
{
    public function isValidUuid(?string $uuid): bool
    {
        return preg_match(
                '/^[a-f\d]{8}(-[a-f\d]{4}){4}[a-f\d]{8}$/i',
                $uuid
            ) === 1;
    }

    public function correctPagination(int &$page, int &$limit): void
    {
        if ($page < 1) {
            $page = 1;
        }

        if ($limit < 1) {
            $limit = 12;
        }
    }
}
