<?php

namespace App\Shared\Repository;

use App\Shared\Entity\NewsCategories;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;
use Ramsey\Collection\Collection;

/**
 * @extends ServiceEntityRepository<NewsCategories>
 *
 * @method NewsCategories|null find($id, $lockMode = null, $lockVersion = null)
 * @method NewsCategories|null findOneBy(array $criteria, array $orderBy = null)
 * @method NewsCategories[]    findAll()
 * @method NewsCategories[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class NewsCategoriesRepository extends ServiceEntityRepository{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, NewsCategories::class);
    }

    /**
     * Возвращает все сущности
     * @return Collection<NewsCategories>
     */
    public function getAll(): Collection
    {
        return new Collection(NewsCategories::class, $this->findAll());
    }
}
