<?php

namespace App\Shared\Abstraction;

use App\Shared\DtoFactory\ErrorDtoFactory;
use App\Shared\Error\BaseError;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController as BundleController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Throwable;

abstract class AbstractController extends BundleController
{
    public function __construct(
        protected readonly ErrorDtoFactory $errorFactory,
    ) {
    }

    /**
     * @param ServiceInterface $service
     * @param int $page
     * @param int $limit
     * @param array<string>|null $filters
     * @return JsonResponse
     */
    protected function handleListing(
        ServiceInterface $service,
        int $page = 1,
        int $limit = 12,
        ?string              ...$filters,
    ): JsonResponse {
        try {
        return new JsonResponse($service->bornListDto($page, $limit, $filters));
        } catch (Throwable) {
            return new JsonResponse([], Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }

    protected function handleDetailElement(
        ServiceInterface $service,
        string $detailId,
    ): JsonResponse {
//        try {
            return new JsonResponse($service->bornDetailElement($detailId));
//        } catch (BaseError $error) {
//            $errorDto = $this->errorFactory->create($error);
//
//            return new JsonResponse($errorDto, $errorDto->status);
//        } catch (Throwable) {
//            return new JsonResponse([], Response::HTTP_INTERNAL_SERVER_ERROR);
//        }
    }
}
