<?php

namespace App\Restaurants\Dto;

use App\Restaurants\Collection\KitchenCollection;
use App\Restaurants\Collection\TagCollection;
use App\Shared\Abstraction\AbstractDetailElement;
use App\Shared\Collection\FileCollection;
use App\Shared\Collection\StringCollection;
use App\Shared\Dto\FileDto;

class RestaurantDetailElementDto extends AbstractDetailElement
{
    /**
     * @param string $id
     * @param string $name
     * @param string $code
     * @param string $coordinates
     * @param RestaurantTypeDto $type
     * @param string|null $check
     * @param string|null $check_info
     * @param KitchenCollection<KitchenTypeDto>|null $kitchen
     * @param StringCollection|null $phone
     * @param StringCollection|null $email
     * @param StringCollection|null $address
     * @param TagCollection<TagDto>|null $tags
     * @param string|null $site
     * @param FileDto|null $image Превью
     * @param FileCollection<FileDto>|null $gallery
     */
    public function __construct(
        public string $id,
        public string $name,
        public string $code,
        public string $coordinates,
        public RestaurantTypeDto $type,
        public ?string $check = null,
        public ?string $check_info = null,
        public ?KitchenCollection $kitchen = null,
        public ?StringCollection $phone = null,
        public ?StringCollection $email = null,
        public ?StringCollection $address = null,
        public ?TagCollection $tags = null,
        public ?string $site = null,
        public ?FileDto $image = null,
        public ?FileCollection $gallery = null,
    ) {}
}
