<?php

namespace App\Restaurants\Controller;

use App\Restaurants\Service\RestaurantPrepareRequestService;
use App\Shared\Abstraction\AbstractController;
use App\Shared\DtoFactory\ErrorDtoFactory;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpKernel\Attribute\MapQueryParameter;
use Symfony\Component\Routing\Attribute\Route;

#[Route('/api/v1/restaurants')]
class RestaurantsController extends AbstractController
{
    public function __construct(
        ErrorDtoFactory $errorFactory,
        private readonly RestaurantPrepareRequestService $responsePrepareService,
    ) {
        parent::__construct($errorFactory);
    }

    #[Route('/', name: 'restaurants', methods: ['GET'])]
    public function restaurants(
        #[MapQueryParameter] int $page = 1,
        #[MapQueryParameter] int $limit = 12,
        #[MapQueryParameter] string $restaurant_type_id = null,
        #[MapQueryParameter] string $kitchen_id = null,
    ): JsonResponse {
        return $this->handleListing(
            $this->responsePrepareService,
            $page,
            $limit,
            $restaurant_type_id,
            $kitchen_id,
        );
    }

    #[Route('/{detailId}', name: 'restaurant', methods: ['GET'])]
    public function restaurant(#[MapQueryParameter] string $detailId = null
    ): JsonResponse {
        return $this->handleDetailElement(
            $this->responsePrepareService,
            $detailId,
        );
    }
}
