<?php

namespace App\News\DtoFactory;

use App\News\Collection\NewsCategoryCollection;
use App\News\Dto\NewsCategoryDto;
use App\Shared\Entity\NewsCategories;
use Ramsey\Collection\Collection;

class NewsCategoryDtoFactory
{
    public function create(NewsCategories $category): NewsCategoryDto
    {
        return new NewsCategoryDto(
            id: $category->getId(),
            name: $category->getName(),
            code: $category->getCode(),
        );
    }

    /**
     * @param Collection<NewsCategories> $categories
     * @return NewsCategoryCollection<NewsCategoryDto>
     */
    public function createCollection(Collection $categories): NewsCategoryCollection
    {
        $categoriesDto = $categories->map(function(NewsCategories $category) {
            return $this->create($category);
        });

        return new NewsCategoryCollection(
            $categoriesDto->toArray()
        );
    }
}
