<?php

namespace App\News\Dto;

use App\Shared\Abstraction\AbstractListDto;
use App\Shared\Collection\ListingCollection;
use App\Shared\Dto\PaginationDto;

class NewsListDto extends AbstractListDto
{
    /**
     * @param PaginationDto $pagination
     * @param ListingCollection<NewsListingElementDto> $list
     * @param NewsFilterVariantsDto $filterVariants
     */
    public function __construct(
        public PaginationDto $pagination,
        public ListingCollection $list,
        public NewsFilterVariantsDto $filterVariants,
    ) {
    }
}
