<?php

namespace App\Controller;

use App\Actions\ReadFileLineByLineAction;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

class ReadFileLineByLineController extends AbstractController
{
    /**
     * Принимает путь до файла,
     * проверяет, что файл существует и выводит пользователю построчный вывод используя yield
     *
     * @param string $filePath путь до файла
     * @return Response  */
    #[Route('/readbyline/{filePath}', name: 'app_read_file_line_by_line')]
    public function index(
        string $filePath,
        ReadFileLineByLineAction $action
    ) : Response {
        $file = "";
        try{
            foreach ($action->act($filePath) as $line) {
                $file .= $line;
            }
        } catch (\Exception $exception) {
            return new Response($exception->getMessage(), Response::HTTP_NOT_FOUND);
        }

        return new Response($file, Response::HTTP_OK);
    }
}
