<?php

namespace App\Requests;

use Symfony\Component\Validator\Constraints\All;
use Symfony\Component\Validator\Constraints\Collection;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\Constraints\Type;
use Symfony\Contracts\Service\Attribute\Required;

class PricesRequest extends BaseRequest
{
    #[Type('array')]
    #[NotBlank()]
    #[Required()]
    #[All(
        constraints: [
            new Collection(
                fields: [
                    'price' => [
                        new NotBlank(),
                        new Type('integer'),
                    ],
                    'count' => [
                        new NotBlank(),
                        new Type('integer'),
                    ],
                ],
            )
        ]
    )]
    public $prices;

    /**
     * серализация реквеста под массив
     * @return mixed
     */
    public function serialise(): mixed
    {
        return $this->prices;
    }
}
