<?php

namespace App\Tests\NewsTests\DataFixtures;

use App\Shared\Entity\File;
use App\Shared\Entity\News;
use App\Shared\Entity\NewsCategories;
use App\Shared\Entity\NewsType;
use DateTimeImmutable;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Persistence\ObjectManager;

class NewsFixture extends Fixture
{
    public function load(ObjectManager $manager): void
    {
        $newsCategory1 = new NewsCategories();
        $newsCategory1->setId('00000000-0000-0000-0000-000000000000');
        $newsCategory1->setName('newsCategory1');
        $newsCategory1->setCode('newsCategory_1');
        $manager->persist($newsCategory1);

        $newsCategory2 = new NewsCategories();
        $newsCategory2->setId('00000000-0000-0000-0000-000000000001');
        $newsCategory2->setName('newsCategory2');
        $newsCategory2->setCode('newsCategory_2');
        $manager->persist($newsCategory2);

        $photo = new File();
        $photo->setId('00000000-0000-0000-0000-000000000000');
        $photo->setName('file1');
        $photo->setDescription('fileDescription');
        $photo->setSize(1024);
        $photo->setType('png');
        $photo->setUrl('/somewhere/');
        $manager->persist($photo);

        $newsType = new NewsType();
        $newsType->setId('00000000-0000-0000-0000-000000000000');
        $newsType->setName('newsType1');
        $newsType->setCode('newsType_1');
        $manager->persist($newsType);

        $news = new News();
        $news->setId('00000000-0000-0000-0000-000000000000');
        $news->setName('news1');
        $news->setCode('news_1');
        $news->setSort(1);
        $news->setActive(true);
        $news->setCreatedAt(new DateTimeImmutable());
        $news->setUpdateAt(new DateTimeImmutable());
        $news->setPreviewImage($photo);
        $news->setDetailImage($photo);
        $news->setPreviewText('Preview text');
        $news->setDetailText('Detail text');
        $news->setMainPageRender(true);
        $news->setType($newsType);
        $news->addCategory($newsCategory1);
        $manager->persist($news);

        $news = new News();
        $news->setId('00000000-0000-0000-0000-000000000001');
        $news->setName('news2');
        $news->setCode('news_2');
        $news->setSort(2);
        $news->setActive(true);
        $news->setCreatedAt(new DateTimeImmutable());
        $news->setUpdateAt(new DateTimeImmutable());
        $news->setPreviewImage(null);
        $news->setDetailImage(null);
        $news->setPreviewText(null);
        $news->setDetailText(null);
        $news->setMainPageRender(false);
        $news->SetType(null);
        $news->addCategory($newsCategory2);
        $manager->persist($news);

        $manager->flush();
    }
}
