<?php

namespace App\Shared\DtoFactory;

use App\Shared\Dto\ValidateErrorDto;
use App\Shared\Error\ErrorCode;
use http\Message;
use Symfony\Component\Validator\ConstraintViolationInterface;

class ValidateErrorDtoFactory
{
    public function create(ConstraintViolationInterface $error): ValidateErrorDto
    {
        return new ValidateErrorDto(
            message: $error->getPropertyPath() . ' : ' . $error->getMessage(),
            code: ErrorCode::ValidateFailed->value,
            status: 422
        );
    }
}
