<?php

namespace App\Restaurants\Service;

use App\Restaurants\DtoFactory\KitchenTypeDtoFactory;
use App\Restaurants\DtoFactory\RestaurantFilterVariantsDtoFactory;
use App\Restaurants\DtoFactory\RestaurantListDtoFactory;
use App\Restaurants\DtoFactory\RestaurantListingElementDtoFactory;
use App\Restaurants\DtoFactory\RestaurantTypeDtoFactory;
use App\Shared\Abstraction\AbstractRequest;
use App\Shared\Abstraction\DtoInterface;
use App\Shared\Abstraction\ServiceInterface;
use App\Shared\DtoFactory\PaginationDtoFactory;
use App\Shared\Repository\KitchensRepository;
use App\Shared\Repository\RestaurantsRepository;
use App\Shared\Repository\RestaurantTypesRepository;

class RestaurantListingService implements ServiceInterface
{
    public function __construct(
        private readonly RestaurantsRepository $restaurants,
        private readonly RestaurantTypesRepository $types,
        private readonly KitchensRepository $kitchens,

        private readonly PaginationDtoFactory $paginationFactory,
        private readonly RestaurantListingElementDtoFactory $listFactory,
        private readonly RestaurantFilterVariantsDtoFactory $filterFactory,
        private readonly RestaurantTypeDtoFactory $typeFactory,
        private readonly KitchenTypeDtoFactory $kitchenFactory,
        private readonly RestaurantListDtoFactory $listingFactory,
    ) {}

    public function serve(AbstractRequest $request): DtoInterface
    {
        $countOfRestaurants = $this
            ->restaurants
            ->getCountWithFilters(
                $request->restaurant_type_id,
                $request->kitchen_id
            );

        $pagination = $this->paginationFactory->create(
            $request->page,
            $request->limit,
            $countOfRestaurants,
        );

        $offset = min($pagination->pageSize, $countOfRestaurants) * ($pagination->currentPage - 1);

        $list = $this->listFactory->createCollection(
            $this->restaurants->getWithFilters(
                $request->kitchen_id,
                $request->restaurant_type_id,
                $pagination->pageSize,
                $offset,
            ),
        );


        $filters = $this->filterFactory->create(
            $this->typeFactory->createCollection($this->types->getAll()),
            $this->kitchenFactory->createCollection($this->kitchens->getAll())
        );

        return $this->listingFactory->create(
            $pagination,
            $list,
            $filters
        );
    }
}
