<?php

namespace App\Restaurants\DtoFactory;

use App\Restaurants\Dto\TagDto;
use App\Shared\Dto\DtoCollection;
use JsonException;
use Ramsey\Collection\Collection as RamseyCollection;

class TagDtoFactory
{
    /**
     * @param string $json
     * @return DtoCollection<TagDto>
     * @throws JsonException
     */
    public function createCollection(string $json): DtoCollection
    {
        $jsonCollection = new RamseyCollection(
            'array',
            json_decode(
                $json,
                true,
                512,
                JSON_THROW_ON_ERROR
            )
        );

        $tagCollection = new DtoCollection(TagDto::class);

        foreach ($jsonCollection as $name => $jsonItem) {
            $tagCollection->add(
                new TagDto($name, new DtoCollection('string', $jsonItem))
            );
        }

        return $tagCollection;
    }
}
