<?php

namespace App\Restaurants\DtoFactory;

use App\Restaurants\Dto\RestaurantFilterVariantsDto;
use App\Restaurants\Dto\RestaurantListDto;
use App\Restaurants\Dto\RestaurantListingElementDto;
use App\Shared\Dto\DtoCollection;
use App\Shared\Dto\PaginationDto;

class RestaurantListDtoFactory
{
    /**
     * @param PaginationDto $pagination
     * @param DtoCollection<RestaurantListingElementDto> $list
     * @param RestaurantFilterVariantsDto $filters
     * @return RestaurantListDto
     */
    public function create(
        PaginationDto $pagination,
        DtoCollection $list,
        RestaurantFilterVariantsDto $filters
    ): RestaurantListDto {
        return new RestaurantListDto(
            $pagination,
            $list,
            $filters
        );
    }
}
