<?php

namespace App\Restaurants\DtoFactory;

use App\Restaurants\Dto\RestaurantDetailElementDto;
use App\Shared\Dto\DtoCollection;
use App\Shared\DtoFactory\FileDtoFactory;
use App\Shared\Entity\Restaurants;

class RestaurantDetailElementDtoFactory
{
    public function __construct(
        private readonly RestaurantTypeDtoFactory $typeFactory,
        private readonly KitchenTypeDtoFactory $kitchenFactory,
        private readonly TagDtoFactory $tagFactory,
        private readonly FileDtoFactory $fileFactory,
    ) {}
    public function create(Restaurants $restaurant): RestaurantDetailElementDto
    {
        return new RestaurantDetailElementDto(
            id: $restaurant->getId(),
            name: $restaurant->getName(),
            code: $restaurant->getCode(),
            coordinates: $restaurant->getCoordinates(),
            type: $this->typeFactory->create($restaurant->getType()),
            check: $restaurant->getReceipt(),
            check_info: $restaurant->getReceiptInfo(),
            kitchen: $this->kitchenFactory->createCollection($restaurant->getKitchens()),
            phone: $this->decodeJson($restaurant->getPhone()),
            email: $this->decodeJson($restaurant->getEmail()),
            address: $this->decodeJson($restaurant->getAddress()),
            tags: $this->tagFactory->createCollection($restaurant->getTags()),
            site: $restaurant->getSite(),
            image: $this->fileFactory->create($restaurant->getPreviewImage()),
            gallery: $this->fileFactory->createCollection($restaurant->getGallery()),
        );
    }

    /**
     * @throws \JsonException
     */
    private function decodeJson(string $json)
    {
        return $json === null
            ? null
            : new DtoCollection(
                'string',
                json_decode(
                    $json,
                    true,
                    512,
                    JSON_THROW_ON_ERROR
                ),
            );
    }
}