<?php

namespace App\Restaurants\DtoFactory;

use App\Restaurants\Dto\KitchenTypeDto;
use App\Shared\Dto\DtoCollection;
use App\Shared\Entity\Kitchens;
use Ramsey\Collection\Collection as RamseyCollection;
use Doctrine\Common\Collections\Collection as DoctrineCollection;

class KitchenTypeDtoFactory
{
    public function create(Kitchens $kitchen): KitchenTypeDto
    {
        return new KitchenTypeDto(
            id: $kitchen->getId(),
            name: $kitchen->getName(),
            code: $kitchen->getCode(),
        );
    }

    /**
     * @param DoctrineCollection<Kitchens>|RamseyCollection<Kitchens> $kitchens
     * @return DtoCollection<KitchenTypeDto>
     */
    public function createCollection(DoctrineCollection|RamseyCollection $kitchens): DtoCollection
    {
        $kitchenCollection = $kitchens->map(function(Kitchens $kitchen) {
            return $this->create($kitchen);
        });

        return new DtoCollection(
            KitchenTypeDto::class,
            $kitchenCollection->toArray()
        );
    }
}
