<?php

namespace App\Restaurants\Controller;

use App\Restaurants\Request\RestaurantListingRequest;
use App\Restaurants\Service\RestaurantDetailService;
use App\Restaurants\Service\RestaurantListingService;
use App\Shared\Abstraction\AbstractController;
use App\Shared\DtoFactory\ErrorDtoFactory;
use App\Shared\Request\DetailRequest;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Attribute\Route;

#[Route('/api/v1/restaurants')]
class RestaurantsController extends AbstractController
{
    public function __construct(
        ErrorDtoFactory $errorFactory,

        private readonly RestaurantListingService $listingService,
        private readonly RestaurantDetailService $detailService,
    ) {
        parent::__construct($errorFactory);
    }

    #[Route('/', name: 'restaurants', methods: ['GET'])]
    public function restaurants(RestaurantListingRequest $request): JsonResponse
    {
        return $this->handle($this->listingService, $request);
    }

    #[Route('/{detailId}', name: 'restaurant', methods: ['GET'])]
    public function restaurant(DetailRequest $request): JsonResponse
    {
        return $this->handle($this->detailService, $request);
    }
}
