<?php

namespace App\News\Service;

use App\News\Dto\NewsDetailElementDto;
use App\News\DtoFactory\NewsDetailElementDtoFactory;
use App\Shared\Abstraction\AbstractRequest;
use App\Shared\Abstraction\ServiceInterface;
use App\Shared\Repository\NewsRepository;

class NewsSearchService implements ServiceInterface
{
    public function __construct(
        private readonly NewsRepository $news,

        private readonly NewsDetailElementDtoFactory $dtoFactory,
    ) {}
    public function serve(AbstractRequest $request): NewsDetailElementDto
    {
        return $this->dtoFactory->create($this->news->getMainNews());
    }
}
