<?php

namespace App\News\Service;

use App\News\Dto\NewsListingElementDto;
use App\News\DtoFactory\NewsListingElementDtoFactory;
use App\Shared\Abstraction\AbstractRequest;
use App\Shared\Abstraction\ServiceInterface;
use App\Shared\Repository\NewsRepository;

class NewsMainNewsService implements ServiceInterface
{
    public function __construct(
        private readonly NewsRepository $news,

        private readonly NewsListingElementDtoFactory $dtoFactory,
    ) {}
    public function serve(AbstractRequest $request): NewsListingElementDto
    {
        return $this->dtoFactory->create($this->news->getMainNews());
    }
}
