<?php

namespace App\News\Service;

use App\News\Dto\NewsDetailElementDto;
use App\News\DtoFactory\NewsDetailElementDtoFactory;
use App\Shared\Abstraction\AbstractRequest;
use App\Shared\Abstraction\ServiceInterface;
use App\Shared\Error\NotFoundError;
use App\Shared\Repository\NewsRepository;

class NewsDetailService implements ServiceInterface
{
    public function __construct(
        private readonly NewsRepository $news,

        private readonly NewsDetailElementDtoFactory $dtoFactory,
    ) {}

    /**
     * @throws NotFoundError
     */
    public function serve(AbstractRequest $request): NewsDetailElementDto
    {
        $news = $this->news->find($request->detailId);

        return $news !== null
            ? $this->dtoFactory->create($news)
            :  throw new NotFoundError('News not found');
    }
}
