<?php

namespace App\News\Dto;

use App\Shared\Abstraction\DtoInterface;
use App\Shared\Dto\FileDto;

class NewsListingElementDto implements DtoInterface
{
    /**
     * @param string $id
     * @param string $name
     * @param string $create_at
     * @param string $detail_link
     * @param string|null $description
     * @param FileDto|null $image Превью
     */
    public function __construct(
        public string $id,

        public string $name,

        public string $createAt,

        public string $detailLink,

        public ?string $description = null,

        public ?FileDto $image = null,
    ) {}
}
