<?php

namespace App\News\Dto;

use App\Shared\Abstraction\DtoInterface;
use App\Shared\Dto\DtoCollection;
use App\Shared\Dto\PaginationDto;

class NewsListDto implements DtoInterface
{
    /**
     * @param PaginationDto $pagination
     * @param DtoCollection<NewsListingElementDto> $list
     * @param NewsFilterVariantsDto $filterVariants
     */
    public function __construct(
        public PaginationDto         $pagination,

        public DtoCollection         $list,

        public NewsFilterVariantsDto $filterVariants,
    ) {}
}
