<?php

namespace App\Shared\Repository;

use App\Shared\Entity\NewsType;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;
use Ramsey\Collection\Collection;

/**
 * @extends ServiceEntityRepository<NewsType>
 *
 * @method NewsType|null find($id, $lockMode = null, $lockVersion = null)
 * @method NewsType|null findOneBy(array $criteria, array $orderBy = null)
 * @method NewsType[]    findAll()
 * @method NewsType[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class NewsTypeRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, NewsType::class);
    }

    /** @return Collection<NewsType> */
    public function getAll(): Collection
    {
        return new Collection(NewsType::class, $this->findAll());
    }
}
