<?php

namespace App\Shared\EventListener;

use App\Shared\Entity\News;
use App\Shared\Entity\Restaurants;
use App\Shared\Repository\NewsRepository;
use App\Shared\Repository\RestaurantsRepository;
use Doctrine\Bundle\DoctrineBundle\Attribute\AsEntityListener;
use Doctrine\ORM\Event\PreFlushEventArgs;
use Doctrine\ORM\Events;

#[AsEntityListener(event: Events::preFlush, method: 'preFlush', entity: Restaurants::class)]
class RestaurantPerCreate
{
    public function __construct(
        private readonly RestaurantsRepository $restaurantsRepository,
    ) {}
    public function preFlush(Restaurants $restaurant, PreFlushEventArgs $args)
    {
        if ($restaurant->getSort() === null) {
            $restaurant->setSort($this->restaurantsRepository->getMaxValueSort() + 1);
        }
    }
}
