<?php

namespace App\Restaurants\UseCase;

use App\Restaurants\Request\RestaurantFullUpdateRequest;
use App\Restaurants\Service\RestaurantPrepareResponseService;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Throwable;

class RestaurantFullUpdateUseCase
{
    public function __construct(
        private readonly RestaurantPrepareResponseService $prepareRequestService,
    ) {
    }

    public function execute(RestaurantFullUpdateRequest $request): Response
    {
        try {
            $this->prepareRequestService->reborn($request);
            return new Response();
        } catch (Throwable) {
            return new JsonResponse([], Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }
}
