<?php

namespace App\Restaurants\UseCase;

use App\Restaurants\Request\RestaurantDetailRequest;
use App\Restaurants\Service\RestaurantPrepareResponseService;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Throwable;

class RestaurantDeleteUseCase
{
    public function __construct(
        private readonly RestaurantPrepareResponseService $prepareRequestService,
    ) {
    }

    public function execute(RestaurantDetailRequest $request): Response
    {
        try {
            $this->prepareRequestService->unbirth($request);
            return new Response();
        } catch (Throwable) {
            return new JsonResponse([], Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }
}
