<?php

namespace App\Restaurants\DtoFactory;

use App\Restaurants\Collection\RestaurantListingElementCollection;
use App\Restaurants\Dto\RestaurantFilterVariantsDto;
use App\Restaurants\Dto\RestaurantListDto;
use App\Restaurants\Dto\RestaurantListingElementDto;
use App\Shared\Dto\PaginationDto;

class RestaurantListDtoFactory
{
    /**
     * @param PaginationDto $pagination
     * @param RestaurantListingElementCollection<RestaurantListingElementDto> $list
     * @param RestaurantFilterVariantsDto $filters
     * @return RestaurantListDto
     */
    public function create(
        PaginationDto $pagination,
        RestaurantListingElementCollection $list,
        RestaurantFilterVariantsDto $filters
    ): RestaurantListDto {
        return new RestaurantListDto(
            $pagination,
            $list,
            $filters
        );
    }
}
