<?php

namespace App\News\UseCase;

use App\News\Request\NewsCreateRequest;
use App\News\Service\NewsPrepareResponseService;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Throwable;

class NewsCreateUseCase
{
    public function __construct(
        private readonly NewsPrepareResponseService $prepareRequestService,
    ) {
    }

    public function execute(NewsCreateRequest $request): Response
    {
        try {
            $this->prepareRequestService->birth($request);
            return new Response();
        } catch (Throwable) {
            return new JsonResponse([], Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }
}
