<?php

namespace App\News\Request;

use App\Shared\Abstraction\AbstractRequest;
use Symfony\Component\Validator\Constraints\All;
use Symfony\Component\Validator\Constraints\Type;
use Symfony\Component\Validator\Constraints\Uuid;
use Symfony\Contracts\Service\Attribute\Required;

class NewsPartUpdateRequest extends AbstractRequest
{
    #[Uuid]
    #[Required]
    public $id;

    #[Type('string')]
    public $name;

    #[Type('string')]
    public $code;

    #[Type('bool')]
    public $active;

    #[Type('bool')]
    public bool $main_page_render;

    public $preview_text;

    public  $detail_text;

    #[Uuid]
    public  $type_id;

    #[All(
        new Uuid()
    )]
    public $categories_id;

    #[Uuid]
    public $detail_image;

    #[Uuid]
    public $preview_image;
}
