<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20240520053704 extends AbstractMigration
{
    public function getDescription(): string
    {
        return '';
    }

    public function up(Schema $schema): void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->addSql('CREATE TABLE file (id UUID NOT NULL, name VARCHAR(255) NOT NULL, description VARCHAR(255) NOT NULL, size INT NOT NULL, type VARCHAR(255) NOT NULL, url VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE TABLE kitchens (id UUID NOT NULL, name VARCHAR(255) NOT NULL, code VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE TABLE news (id UUID NOT NULL, type_id UUID DEFAULT NULL, detail_image_id UUID DEFAULT NULL, preview_image_id UUID DEFAULT NULL, name VARCHAR(255) NOT NULL, code VARCHAR(255) NOT NULL, sort INT NOT NULL, active BOOLEAN NOT NULL, created_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, update_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, preview_text VARCHAR(1000) DEFAULT NULL, detail_text VARCHAR(255) DEFAULT NULL, main_page_render BOOLEAN NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_1DD39950C54C8C93 ON news (type_id)');
        $this->addSql('CREATE INDEX IDX_1DD39950CB7BCCB6 ON news (detail_image_id)');
        $this->addSql('CREATE INDEX IDX_1DD39950FAE957CD ON news (preview_image_id)');
        $this->addSql('COMMENT ON COLUMN news.created_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('COMMENT ON COLUMN news.update_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('CREATE TABLE news_news_categories (news_id UUID NOT NULL, news_categories_id UUID NOT NULL, PRIMARY KEY(news_id, news_categories_id))');
        $this->addSql('CREATE INDEX IDX_34AB0102B5A459A0 ON news_news_categories (news_id)');
        $this->addSql('CREATE INDEX IDX_34AB0102F7F178F1 ON news_news_categories (news_categories_id)');
        $this->addSql('CREATE TABLE news_categories (id UUID NOT NULL, name VARCHAR(255) NOT NULL, code VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE TABLE news_type (id UUID NOT NULL, name VARCHAR(255) NOT NULL, code VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE TABLE restaurant_types (id UUID NOT NULL, name VARCHAR(255) NOT NULL, code VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE TABLE restaurants (id UUID NOT NULL, type_id UUID DEFAULT NULL, settlement_id UUID DEFAULT NULL, preview_image_id UUID DEFAULT NULL, detail_image_id UUID DEFAULT NULL, active BOOLEAN NOT NULL, sort INT NOT NULL, created_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, update_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, name VARCHAR(255) NOT NULL, code VARCHAR(255) NOT NULL, description VARCHAR(255) NOT NULL, receipt VARCHAR(255) NOT NULL, receipt_info VARCHAR(255) NOT NULL, phone VARCHAR(255) NOT NULL, email VARCHAR(255) NOT NULL, address VARCHAR(255) NOT NULL, tags VARCHAR(255) NOT NULL, site VARCHAR(255) NOT NULL, coordinates VARCHAR(1000) NOT NULL, how_to_find VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_AD837724C54C8C93 ON restaurants (type_id)');
        $this->addSql('CREATE INDEX IDX_AD837724C2B9C425 ON restaurants (settlement_id)');
        $this->addSql('CREATE INDEX IDX_AD837724FAE957CD ON restaurants (preview_image_id)');
        $this->addSql('CREATE INDEX IDX_AD837724CB7BCCB6 ON restaurants (detail_image_id)');
        $this->addSql('COMMENT ON COLUMN restaurants.created_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('COMMENT ON COLUMN restaurants.update_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('CREATE TABLE restaurants_kitchens (restaurants_id UUID NOT NULL, kitchens_id UUID NOT NULL, PRIMARY KEY(restaurants_id, kitchens_id))');
        $this->addSql('CREATE INDEX IDX_716464694DCA160A ON restaurants_kitchens (restaurants_id)');
        $this->addSql('CREATE INDEX IDX_71646469E043FCBC ON restaurants_kitchens (kitchens_id)');
        $this->addSql('CREATE TABLE restaurants_file (restaurants_id UUID NOT NULL, file_id UUID NOT NULL, PRIMARY KEY(restaurants_id, file_id))');
        $this->addSql('CREATE INDEX IDX_EBC930974DCA160A ON restaurants_file (restaurants_id)');
        $this->addSql('CREATE INDEX IDX_EBC9309793CB796C ON restaurants_file (file_id)');
        $this->addSql('CREATE TABLE settlements (id UUID NOT NULL, active BOOLEAN NOT NULL, created_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, update_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, name VARCHAR(255) NOT NULL, code VARCHAR(255) NOT NULL, coordinates TEXT NOT NULL, PRIMARY KEY(id))');
        $this->addSql('COMMENT ON COLUMN settlements.created_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('COMMENT ON COLUMN settlements.update_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('COMMENT ON COLUMN settlements.coordinates IS \'(DC2Type:array)\'');
        $this->addSql('CREATE TABLE users (id UUID NOT NULL, name VARCHAR(255) NOT NULL, email VARCHAR(255) NOT NULL, phone VARCHAR(255) NOT NULL, is_male BOOLEAN NOT NULL, address VARCHAR(255) NOT NULL, birthday DATE NOT NULL, PRIMARY KEY(id))');
        $this->addSql('COMMENT ON COLUMN users.birthday IS \'(DC2Type:date_immutable)\'');
        $this->addSql('CREATE TABLE messenger_messages (id BIGSERIAL NOT NULL, body TEXT NOT NULL, headers TEXT NOT NULL, queue_name VARCHAR(190) NOT NULL, created_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, available_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, delivered_at TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_75EA56E0FB7336F0 ON messenger_messages (queue_name)');
        $this->addSql('CREATE INDEX IDX_75EA56E0E3BD61CE ON messenger_messages (available_at)');
        $this->addSql('CREATE INDEX IDX_75EA56E016BA31DB ON messenger_messages (delivered_at)');
        $this->addSql('COMMENT ON COLUMN messenger_messages.created_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('COMMENT ON COLUMN messenger_messages.available_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('COMMENT ON COLUMN messenger_messages.delivered_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('CREATE OR REPLACE FUNCTION notify_messenger_messages() RETURNS TRIGGER AS $$
            BEGIN
                PERFORM pg_notify(\'messenger_messages\', NEW.queue_name::text);
                RETURN NEW;
            END;
        $$ LANGUAGE plpgsql;');
        $this->addSql('DROP TRIGGER IF EXISTS notify_trigger ON messenger_messages;');
        $this->addSql('CREATE TRIGGER notify_trigger AFTER INSERT OR UPDATE ON messenger_messages FOR EACH ROW EXECUTE PROCEDURE notify_messenger_messages();');
        $this->addSql('ALTER TABLE news ADD CONSTRAINT FK_1DD39950C54C8C93 FOREIGN KEY (type_id) REFERENCES news_type (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE news ADD CONSTRAINT FK_1DD39950CB7BCCB6 FOREIGN KEY (detail_image_id) REFERENCES file (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE news ADD CONSTRAINT FK_1DD39950FAE957CD FOREIGN KEY (preview_image_id) REFERENCES file (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE news_news_categories ADD CONSTRAINT FK_34AB0102B5A459A0 FOREIGN KEY (news_id) REFERENCES news (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE news_news_categories ADD CONSTRAINT FK_34AB0102F7F178F1 FOREIGN KEY (news_categories_id) REFERENCES news_categories (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE restaurants ADD CONSTRAINT FK_AD837724C54C8C93 FOREIGN KEY (type_id) REFERENCES restaurant_types (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE restaurants ADD CONSTRAINT FK_AD837724C2B9C425 FOREIGN KEY (settlement_id) REFERENCES settlements (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE restaurants ADD CONSTRAINT FK_AD837724FAE957CD FOREIGN KEY (preview_image_id) REFERENCES file (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE restaurants ADD CONSTRAINT FK_AD837724CB7BCCB6 FOREIGN KEY (detail_image_id) REFERENCES file (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE restaurants_kitchens ADD CONSTRAINT FK_716464694DCA160A FOREIGN KEY (restaurants_id) REFERENCES restaurants (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE restaurants_kitchens ADD CONSTRAINT FK_71646469E043FCBC FOREIGN KEY (kitchens_id) REFERENCES kitchens (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE restaurants_file ADD CONSTRAINT FK_EBC930974DCA160A FOREIGN KEY (restaurants_id) REFERENCES restaurants (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE restaurants_file ADD CONSTRAINT FK_EBC9309793CB796C FOREIGN KEY (file_id) REFERENCES file (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
    }

    public function down(Schema $schema): void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->addSql('CREATE SCHEMA public');
        $this->addSql('ALTER TABLE news DROP CONSTRAINT FK_1DD39950C54C8C93');
        $this->addSql('ALTER TABLE news DROP CONSTRAINT FK_1DD39950CB7BCCB6');
        $this->addSql('ALTER TABLE news DROP CONSTRAINT FK_1DD39950FAE957CD');
        $this->addSql('ALTER TABLE news_news_categories DROP CONSTRAINT FK_34AB0102B5A459A0');
        $this->addSql('ALTER TABLE news_news_categories DROP CONSTRAINT FK_34AB0102F7F178F1');
        $this->addSql('ALTER TABLE restaurants DROP CONSTRAINT FK_AD837724C54C8C93');
        $this->addSql('ALTER TABLE restaurants DROP CONSTRAINT FK_AD837724C2B9C425');
        $this->addSql('ALTER TABLE restaurants DROP CONSTRAINT FK_AD837724FAE957CD');
        $this->addSql('ALTER TABLE restaurants DROP CONSTRAINT FK_AD837724CB7BCCB6');
        $this->addSql('ALTER TABLE restaurants_kitchens DROP CONSTRAINT FK_716464694DCA160A');
        $this->addSql('ALTER TABLE restaurants_kitchens DROP CONSTRAINT FK_71646469E043FCBC');
        $this->addSql('ALTER TABLE restaurants_file DROP CONSTRAINT FK_EBC930974DCA160A');
        $this->addSql('ALTER TABLE restaurants_file DROP CONSTRAINT FK_EBC9309793CB796C');
        $this->addSql('DROP TABLE file');
        $this->addSql('DROP TABLE kitchens');
        $this->addSql('DROP TABLE news');
        $this->addSql('DROP TABLE news_news_categories');
        $this->addSql('DROP TABLE news_categories');
        $this->addSql('DROP TABLE news_type');
        $this->addSql('DROP TABLE restaurant_types');
        $this->addSql('DROP TABLE restaurants');
        $this->addSql('DROP TABLE restaurants_kitchens');
        $this->addSql('DROP TABLE restaurants_file');
        $this->addSql('DROP TABLE settlements');
        $this->addSql('DROP TABLE users');
        $this->addSql('DROP TABLE messenger_messages');
    }
}
