<?php

namespace App\Shared\EventListener;

use App\Shared\Entity\News;
use App\Shared\Repository\NewsRepository;
use Doctrine\Bundle\DoctrineBundle\Attribute\AsEntityListener;
use Doctrine\ORM\Event\PreFlushEventArgs;
use Doctrine\ORM\Events;

#[AsEntityListener(event: Events::preFlush, method: 'preFlush', entity: News::class)]
class NewsPerCreate
{
    public function __construct(
        private readonly NewsRepository $newsRepository,
    ) {}
    public function preFlush(News $news, PreFlushEventArgs $args)
    {
        if ($news->getSort() === null) {
            $news->setSort($news->getSort() + 1);
        }

        if ($news->isMainPageRender()) {
            $mainNews = $this->newsRepository->getMainNews();
            $mainNews?->setMainPageRender(false);
        }
    }
}
