<?php

namespace App\Restaurants\Request;

use App\Shared\Abstraction\AbstractRequest;
use Symfony\Component\Validator\Constraints\All;
use Symfony\Component\Validator\Constraints\Type;
use Symfony\Component\Validator\Constraints\Uuid;

class RestaurantPartUpdateRequest extends AbstractRequest
{
    #[Uuid]
    public $uuid;
    
    #[Type('bool')]
    public $active;

    #[Type('string')]
    public $name;

    #[Type('string')]
    public $description;

    #[Type('string')]
    public $code;

    #[Type('string')]
    public $check;

    #[Type('string')]
    public $receipt_info;

    #[Type('array')]
    #[All(
        new Type('string')
    )]
    public $phone;

    #[Type('array')]
    #[All(
        new Type('string')
    )]
    public $email;

    #[Type('array')]
    #[All(
        new Type('string')
    )]
    public $address;

    #[Type('array')]
    #[All([
        new Type('array'),
        new All(
            new Type('string')
        )
    ])]
    public $tags;

    #[Type('string')]
    public $site;

    #[Type('string')]
    public $coordinates;

    #[Type('string')]
    public $how_to_find;

    #[Uuid]
    public $type_id;

    #[Uuid]
    public $settelement_id;

    #[Uuid]
    public $preview_image_id;

    #[Uuid]
    public $detail_inage_id;

    #[Uuid]
    public $kitchens_id;

    #[Type('array')]
    #[All(
        new UUid(),
    )]
    public $gallery;
}