<?php

namespace App\Restaurants\Request;

use App\Shared\Error\NotFoundError;
use App\Shared\Service\ValidationService;
use Symfony\Component\HttpFoundation\Request;

class RestaurantDetailRequest
{
    public string $detailId;

    public function __construct(
        private readonly ValidationService $validation,
    ) {
        $this->populate();
        $this->checkAndCorrectParams();
    }

    private function checkAndCorrectParams(): void
    {
        if (!$this->validation->isUuidValid($this->detailId)) {
            throw new NotFoundError('Restaurant not found');
        }
    }

    private function populate(): void
    {
        $requestUrl = $this->getRequest()->getUri();
        $index = strrpos($requestUrl, "/") + 1;

        $restaurantId = substr($requestUrl, $index);

        if (property_exists($this, "detailId")) {
            $this->{"detailId"} = $restaurantId;
        }
    }

    public function getRequest(): Request
    {
        return Request::createFromGlobals();
    }
}
