<?php

namespace App\News\Request;

use App\Shared\Service\ValidationService;
use Symfony\Component\HttpFoundation\Request;

class NewsListingRequest
{
    public int $page = 1;
    public int $limit = 12;
    public ?string $news_category = null;

    public function __construct(
        private readonly ValidationService $validation,
    ) {
        $this->populate();
        $this->checkAndCorrectParams();
    }

    private function checkAndCorrectParams(): void
    {
        if (!$this->validation->isPageValid($this->page)) {
            $this->page = 1;
        }

        if (!$this->validation->isLimitValid($this->limit)) {
            $this->limit = 12;
        }

        if (!$this->validation->isUuidValid($this->news_category)) {
            $this->news_category = null;
        }
    }

    private function populate(): void
    {
        foreach (
            $this->getRequest()->query->getIterator() as $property => $value
        ) {
            if (property_exists($this, $property)) {
                $this->{$property} = $value;
            }
        }
    }

    public function getRequest(): Request
    {
        return Request::createFromGlobals();
    }
}