<?php

namespace App\News\Request;

use App\Shared\Abstraction\AbstractRequest;
use Symfony\Component\Validator\Constraints\All;
use Symfony\Component\Validator\Constraints\Type;
use Symfony\Component\Validator\Constraints\Uuid;
use Symfony\Contracts\Service\Attribute\Required;

class NewsFullUpdateRequest extends AbstractRequest
{
    #[Required]
    #[Uuid]
    public $id;

    #[Required]
    #[Type('string')]
    public $name;

    #[Required]
    #[Type('string')]
    public $code;

    #[Required]
    #[Type('bool')]
    public $active;

    #[Required]
    #[Type('bool')]
    public $main_page_render;

    public $preview_text;

    public $detail_text;

    #[Uuid]
    #[Required]
    public $type_id;

    #[All(
        new Uuid()
    )]
    public $categories_uuid;

    #[Uuid]
    public $detail_image;

    #[Uuid]
    public $preview_image;
}
