<?php

namespace App\Entity;

use App\Repository\SettlementsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: SettlementsRepository::class)]
class Settlements
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(type: Types::GUID)]
    private ?string $uuid = null;

    #[ORM\Column(length: 255)]
    private ?string $name = null;

    #[ORM\Column(length: 255)]
    private ?string $code = null;

    #[ORM\Column(type: Types::ARRAY)]
    private array $coordinates = [];

    #[ORM\Column]
    private ?\DateTimeImmutable $create_at = null;

    #[ORM\Column(type: Types::DATETIME_MUTABLE)]
    private ?\DateTimeInterface $update_at = null;

    /**
     * @var Collection<int, Restaurants>
     */
    #[ORM\OneToMany(targetEntity: Restaurants::class, mappedBy: 'settlement_id')]
    private Collection $restaurant_id;

    public function __construct()
    {
        $this->restaurant_id = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getUuid(): ?string
    {
        return $this->uuid;
    }

    public function setUuid(string $uuid): static
    {
        $this->uuid = $uuid;

        return $this;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): static
    {
        $this->name = $name;

        return $this;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(string $code): static
    {
        $this->code = $code;

        return $this;
    }

    public function getCoordinates(): array
    {
        return $this->coordinates;
    }

    public function setCoordinates(array $coordinates): static
    {
        $this->coordinates = $coordinates;

        return $this;
    }

    public function getCreateAt(): ?\DateTimeImmutable
    {
        return $this->create_at;
    }

    public function setCreateAt(\DateTimeImmutable $create_at): static
    {
        $this->create_at = $create_at;

        return $this;
    }

    public function getUpdateAt(): ?\DateTimeInterface
    {
        return $this->update_at;
    }

    public function setUpdateAt(\DateTimeInterface $update_at): static
    {
        $this->update_at = $update_at;

        return $this;
    }

    /**
     * @return Collection<int, Restaurants>
     */
    public function getRestaurantId(): Collection
    {
        return $this->restaurant_id;
    }

    public function addRestaurantId(Restaurants $restaurantId): static
    {
        if (!$this->restaurant_id->contains($restaurantId)) {
            $this->restaurant_id->add($restaurantId);
            $restaurantId->setSettlementId($this);
        }

        return $this;
    }

    public function removeRestaurantId(Restaurants $restaurantId): static
    {
        if ($this->restaurant_id->removeElement($restaurantId)) {
            // set the owning side to null (unless already changed)
            if ($restaurantId->getSettlementId() === $this) {
                $restaurantId->setSettlementId(null);
            }
        }

        return $this;
    }
}
