<?php

namespace App\Entity;

use App\Repository\RestaurantsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: RestaurantsRepository::class)]
class Restaurants
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(type: Types::GUID)]
    private ?string $uuid = null;

    #[ORM\Column(length: 255)]
    private ?string $name = null;

    #[ORM\Column(length: 255)]
    private ?string $code = null;

    #[ORM\Column]
    private ?bool $active = null;

    #[ORM\Column]
    private ?int $sort = null;

    #[ORM\Column]
    private ?\DateTimeImmutable $create_at = null;

    #[ORM\Column(type: Types::DATETIME_MUTABLE)]
    private ?\DateTimeInterface $update_at = null;

    #[ORM\Column(type: Types::ARRAY)]
    private array $coordinates = [];

    #[ORM\ManyToOne(inversedBy: 'restaurants_id')]
    #[ORM\JoinColumn(nullable: false)]
    private ?RestauranTypes $type_id = null;

    #[ORM\ManyToOne(inversedBy: 'restaurant_id')]
    #[ORM\JoinColumn(nullable: false)]
    private ?Settlements $settlement_id = null;

    #[ORM\Column(length: 1000, nullable: true)]
    private ?string $description = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $recipe = null;

    #[ORM\Column(length: 1000, nullable: true)]
    private ?string $recipe_info = null;

    /**
     * @var Collection<int, Kitchens>
     */
    #[ORM\ManyToMany(targetEntity: Kitchens::class, inversedBy: 'restaurants_id')]
    private Collection $kitchens_id;

    /**
     * @var Collection<int, Phone>
     */
    #[ORM\OneToMany(targetEntity: Phone::class, mappedBy: 'restaurant_id')]
    private Collection $phones_id;

    /**
     * @var Collection<int, Email>
     */
    #[ORM\OneToMany(targetEntity: Email::class, mappedBy: 'restaurant_id')]
    private Collection $emails_id;

    /**
     * @var Collection<int, Address>
     */
    #[ORM\OneToMany(targetEntity: Address::class, mappedBy: 'restaurant_id')]
    private Collection $addresses_id;

    /**
     * @var Collection<int, Tags>
     */
    #[ORM\ManyToMany(targetEntity: Tags::class, mappedBy: 'restaurant_id')]
    private Collection $tags_id;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $site = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $preview_image = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $detail_image = null;

    #[ORM\Column(length: 1000, nullable: true)]
    private ?string $how_to_find = null;

    public function __construct()
    {
        $this->kitchens_id = new ArrayCollection();
        $this->phones_id = new ArrayCollection();
        $this->emails_id = new ArrayCollection();
        $this->addresses_id = new ArrayCollection();
        $this->tags_id = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getUuid(): ?string
    {
        return $this->uuid;
    }

    public function setUuid(string $uuid): static
    {
        $this->uuid = $uuid;

        return $this;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): static
    {
        $this->name = $name;

        return $this;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(string $code): static
    {
        $this->code = $code;

        return $this;
    }

    public function isActive(): ?bool
    {
        return $this->active;
    }

    public function setActive(bool $active): static
    {
        $this->active = $active;

        return $this;
    }

    public function getSort(): ?int
    {
        return $this->sort;
    }

    public function setSort(int $sort): static
    {
        $this->sort = $sort;

        return $this;
    }

    public function getCreateAt(): ?\DateTimeImmutable
    {
        return $this->create_at;
    }

    public function setCreateAt(\DateTimeImmutable $create_at): static
    {
        $this->create_at = $create_at;

        return $this;
    }

    public function getUpdateAt(): ?\DateTimeInterface
    {
        return $this->update_at;
    }

    public function setUpdateAt(\DateTimeInterface $update_at): static
    {
        $this->update_at = $update_at;

        return $this;
    }

    public function getCoordinates(): array
    {
        return $this->coordinates;
    }

    public function setCoordinates(array $coordinates): static
    {
        $this->coordinates = $coordinates;

        return $this;
    }

    public function getTypeId(): ?RestauranTypes
    {
        return $this->type_id;
    }

    public function setTypeId(?RestauranTypes $type_id): static
    {
        $this->type_id = $type_id;

        return $this;
    }

    public function getSettlementId(): ?Settlements
    {
        return $this->settlement_id;
    }

    public function setSettlementId(?Settlements $settlement_id): static
    {
        $this->settlement_id = $settlement_id;

        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(?string $description): static
    {
        $this->description = $description;

        return $this;
    }

    public function getRecipe(): ?string
    {
        return $this->recipe;
    }

    public function setRecipe(?string $recipe): static
    {
        $this->recipe = $recipe;

        return $this;
    }

    public function getRecipeInfo(): ?string
    {
        return $this->recipe_info;
    }

    public function setRecipeInfo(string $recipe_info): static
    {
        $this->recipe_info = $recipe_info;

        return $this;
    }

    /**
     * @return Collection<int, Kitchens>
     */
    public function getKitchensId(): Collection
    {
        return $this->kitchens_id;
    }

    public function addKitchensId(Kitchens $kitchensId): static
    {
        if (!$this->kitchens_id->contains($kitchensId)) {
            $this->kitchens_id->add($kitchensId);
        }

        return $this;
    }

    public function removeKitchensId(Kitchens $kitchensId): static
    {
        $this->kitchens_id->removeElement($kitchensId);

        return $this;
    }

    /**
     * @return Collection<int, Phone>
     */
    public function getPhonesId(): Collection
    {
        return $this->phones_id;
    }

    public function addPhonesId(Phone $phonesId): static
    {
        if (!$this->phones_id->contains($phonesId)) {
            $this->phones_id->add($phonesId);
            $phonesId->setRestaurantId($this);
        }

        return $this;
    }

    public function removePhonesId(Phone $phonesId): static
    {
        if ($this->phones_id->removeElement($phonesId)) {
            // set the owning side to null (unless already changed)
            if ($phonesId->getRestaurantId() === $this) {
                $phonesId->setRestaurantId(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, Email>
     */
    public function getEmailsId(): Collection
    {
        return $this->emails_id;
    }

    public function addEmailsId(Email $emailsId): static
    {
        if (!$this->emails_id->contains($emailsId)) {
            $this->emails_id->add($emailsId);
            $emailsId->setRestaurantId($this);
        }

        return $this;
    }

    public function removeEmailsId(Email $emailsId): static
    {
        if ($this->emails_id->removeElement($emailsId)) {
            // set the owning side to null (unless already changed)
            if ($emailsId->getRestaurantId() === $this) {
                $emailsId->setRestaurantId(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, Address>
     */
    public function getAddressesId(): Collection
    {
        return $this->addresses_id;
    }

    public function addAddressesId(Address $addressesId): static
    {
        if (!$this->addresses_id->contains($addressesId)) {
            $this->addresses_id->add($addressesId);
            $addressesId->setRestaurantId($this);
        }

        return $this;
    }

    public function removeAddressesId(Address $addressesId): static
    {
        if ($this->addresses_id->removeElement($addressesId)) {
            // set the owning side to null (unless already changed)
            if ($addressesId->getRestaurantId() === $this) {
                $addressesId->setRestaurantId(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, Tags>
     */
    public function getTagsId(): Collection
    {
        return $this->tags_id;
    }

    public function addTagsId(Tags $tagsId): static
    {
        if (!$this->tags_id->contains($tagsId)) {
            $this->tags_id->add($tagsId);
            $tagsId->addRestaurantId($this);
        }

        return $this;
    }

    public function removeTagsId(Tags $tagsId): static
    {
        if ($this->tags_id->removeElement($tagsId)) {
            $tagsId->removeRestaurantId($this);
        }

        return $this;
    }

    public function getSite(): ?string
    {
        return $this->site;
    }

    public function setSite(?string $site): static
    {
        $this->site = $site;

        return $this;
    }

    public function getPreviewImage(): ?string
    {
        return $this->preview_image;
    }

    public function setPreviewImage(?string $preview_image): static
    {
        $this->preview_image = $preview_image;

        return $this;
    }

    public function getDetailImage(): ?string
    {
        return $this->detail_image;
    }

    public function setDetailImage(string $detail_image): static
    {
        $this->detail_image = $detail_image;

        return $this;
    }

    public function getHowToFind(): ?string
    {
        return $this->how_to_find;
    }

    public function setHowToFind(?string $how_to_find): static
    {
        $this->how_to_find = $how_to_find;

        return $this;
    }
}

