<?php

namespace App\Entity;

use App\Repository\NewsTypeRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: NewsTypeRepository::class)]
class NewsType
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255)]
    private ?string $name = null;

    #[ORM\Column(length: 255)]
    private ?string $code = null;

    /**
     * @var Collection<int, News>
     */
    #[ORM\OneToMany(targetEntity: News::class, mappedBy: 'type_id')]
    private Collection $news_id;

    public function __construct()
    {
        $this->news_id = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): static
    {
        $this->name = $name;

        return $this;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(string $code): static
    {
        $this->code = $code;

        return $this;
    }

    /**
     * @return Collection<int, News>
     */
    public function getNewsId(): Collection
    {
        return $this->news_id;
    }

    public function addNewsId(News $newsId): static
    {
        if (!$this->news_id->contains($newsId)) {
            $this->news_id->add($newsId);
            $newsId->setTypeId($this);
        }

        return $this;
    }

    public function removeNewsId(News $newsId): static
    {
        if ($this->news_id->removeElement($newsId)) {
            // set the owning side to null (unless already changed)
            if ($newsId->getTypeId() === $this) {
                $newsId->setTypeId(null);
            }
        }

        return $this;
    }
}
