<?php

namespace App\Entity;

use App\Repository\NewsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: NewsRepository::class)]
class News
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255)]
    private ?string $code = null;

    #[ORM\Column]
    private ?bool $active = null;

    #[ORM\Column]
    private ?\DateTimeImmutable $create_at = null;

    #[ORM\Column(type: Types::DATETIME_MUTABLE)]
    private ?\DateTimeInterface $update_at = null;

    #[ORM\Column]
    private ?int $sort = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $preview_image = null;

    #[ORM\Column(length: 1000, nullable: true)]
    private ?string $detail_image = null;

    #[ORM\Column(length: 1000, nullable: true)]
    private ?string $preview_text = null;

    #[ORM\Column(length: 1000, nullable: true)]
    private ?string $detail_test = null;

    #[ORM\ManyToOne(inversedBy: 'news_id')]
    #[ORM\JoinColumn(nullable: false)]
    private ?NewsType $type_id = null;

    #[ORM\Column]
    private ?bool $main_page_render = null;

    /**
     * @var Collection<int, NewsComments>
     */
    #[ORM\OneToMany(targetEntity: NewsComments::class, mappedBy: 'news_id')]
    private Collection $news_comments_id;

    public function __construct()
    {
        $this->news_comments_id = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(string $code): static
    {
        $this->code = $code;

        return $this;
    }

    public function isActive(): ?bool
    {
        return $this->active;
    }

    public function setActive(bool $active): static
    {
        $this->active = $active;

        return $this;
    }

    public function getCreateAt(): ?\DateTimeImmutable
    {
        return $this->create_at;
    }

    public function setCreateAt(\DateTimeImmutable $create_at): static
    {
        $this->create_at = $create_at;

        return $this;
    }

    public function getUpdateAt(): ?\DateTimeInterface
    {
        return $this->update_at;
    }

    public function setUpdateAt(\DateTimeInterface $update_at): static
    {
        $this->update_at = $update_at;

        return $this;
    }

    public function getSort(): ?int
    {
        return $this->sort;
    }

    public function setSort(int $sort): static
    {
        $this->sort = $sort;

        return $this;
    }

    public function getPreviewImage(): ?string
    {
        return $this->preview_image;
    }

    public function setPreviewImage(?string $preview_image): static
    {
        $this->preview_image = $preview_image;

        return $this;
    }

    public function getDetailImage(): ?string
    {
        return $this->detail_image;
    }

    public function setDetailImage(?string $detail_image): static
    {
        $this->detail_image = $detail_image;

        return $this;
    }

    public function getPreviewText(): ?string
    {
        return $this->preview_text;
    }

    public function setPreviewText(?string $preview_text): static
    {
        $this->preview_text = $preview_text;

        return $this;
    }

    public function getDetailTest(): ?string
    {
        return $this->detail_test;
    }

    public function setDetailTest(?string $detail_test): static
    {
        $this->detail_test = $detail_test;

        return $this;
    }

    public function getTypeId(): ?NewsType
    {
        return $this->type_id;
    }

    public function setTypeId(?NewsType $type_id): static
    {
        $this->type_id = $type_id;

        return $this;
    }

    public function isMainPageRender(): ?bool
    {
        return $this->main_page_render;
    }

    public function setMainPageRender(bool $main_page_render): static
    {
        $this->main_page_render = $main_page_render;

        return $this;
    }

    /**
     * @return Collection<int, NewsComments>
     */
    public function getNewsCommentsId(): Collection
    {
        return $this->news_comments_id;
    }

    public function addNewsCommentsId(NewsComments $newsCommentsId): static
    {
        if (!$this->news_comments_id->contains($newsCommentsId)) {
            $this->news_comments_id->add($newsCommentsId);
            $newsCommentsId->setNewsId($this);
        }

        return $this;
    }

    public function removeNewsCommentsId(NewsComments $newsCommentsId): static
    {
        if ($this->news_comments_id->removeElement($newsCommentsId)) {
            // set the owning side to null (unless already changed)
            if ($newsCommentsId->getNewsId() === $this) {
                $newsCommentsId->setNewsId(null);
            }
        }

        return $this;
    }
}
