<?php

namespace App\Entity;

use App\Repository\KitchensRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: KitchensRepository::class)]
class Kitchens
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255)]
    private ?string $name = null;

    /**
     * @var Collection<int, Restaurants>
     */
    #[ORM\ManyToMany(targetEntity: Restaurants::class, mappedBy: 'kitchens_id')]
    private Collection $restaurants_id;

    public function __construct()
    {
        $this->restaurants_id = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): static
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return Collection<int, Restaurants>
     */
    public function getRestaurantsId(): Collection
    {
        return $this->restaurants_id;
    }

    public function addRestaurantsId(Restaurants $restaurantsId): static
    {
        if (!$this->restaurants_id->contains($restaurantsId)) {
            $this->restaurants_id->add($restaurantsId);
            $restaurantsId->addKitchensId($this);
        }

        return $this;
    }

    public function removeRestaurantsId(Restaurants $restaurantsId): static
    {
        if ($this->restaurants_id->removeElement($restaurantsId)) {
            $restaurantsId->removeKitchensId($this);
        }

        return $this;
    }
}
