<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20240419135600 extends AbstractMigration
{
    public function getDescription(): string
    {
        return '';
    }

    public function up(Schema $schema): void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->addSql('CREATE SEQUENCE address_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE email_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE kitchens_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE news_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE news_categories_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE news_comments_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE news_type_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE phone_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE restauran_types_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE restaurants_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE settlements_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE tags_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE users_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE TABLE address (id INT NOT NULL, restaurant_id_id INT NOT NULL, address VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_D4E6F8135592D86 ON address (restaurant_id_id)');
        $this->addSql('CREATE TABLE email (id INT NOT NULL, restaurant_id_id INT NOT NULL, email VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_E7927C7435592D86 ON email (restaurant_id_id)');
        $this->addSql('CREATE TABLE kitchens (id INT NOT NULL, name VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE TABLE news (id INT NOT NULL, type_id_id INT NOT NULL, code VARCHAR(255) NOT NULL, active BOOLEAN NOT NULL, create_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, update_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, sort INT NOT NULL, preview_image VARCHAR(255) DEFAULT NULL, detail_image VARCHAR(1000) DEFAULT NULL, preview_text VARCHAR(1000) DEFAULT NULL, detail_test VARCHAR(1000) DEFAULT NULL, main_page_render BOOLEAN NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_1DD39950714819A0 ON news (type_id_id)');
        $this->addSql('COMMENT ON COLUMN news.create_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('CREATE TABLE news_categories (id INT NOT NULL, name VARCHAR(255) NOT NULL, code VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE TABLE news_comments (id INT NOT NULL, news_id_id INT NOT NULL, moderator_id_id INT DEFAULT NULL, user_id_id INT DEFAULT NULL, moderated BOOLEAN DEFAULT NULL, user_name VARCHAR(255) NOT NULL, test VARCHAR(1000) NOT NULL, create_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, update_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_16A0357B5FB1909 ON news_comments (news_id_id)');
        $this->addSql('CREATE INDEX IDX_16A0357BCEB712DF ON news_comments (moderator_id_id)');
        $this->addSql('CREATE INDEX IDX_16A0357B9D86650F ON news_comments (user_id_id)');
        $this->addSql('COMMENT ON COLUMN news_comments.create_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('CREATE TABLE news_type (id INT NOT NULL, name VARCHAR(255) NOT NULL, code VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE TABLE phone (id INT NOT NULL, restaurant_id_id INT NOT NULL, phone_number VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_444F97DD35592D86 ON phone (restaurant_id_id)');
        $this->addSql('CREATE TABLE restauran_types (id INT NOT NULL, name VARCHAR(255) NOT NULL, code VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE TABLE restaurants (id INT NOT NULL, type_id_id INT NOT NULL, settlement_id_id INT NOT NULL, uuid UUID NOT NULL, name VARCHAR(255) NOT NULL, code VARCHAR(255) NOT NULL, active BOOLEAN NOT NULL, sort INT NOT NULL, create_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, update_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, coordinates TEXT NOT NULL, description VARCHAR(1000) DEFAULT NULL, recipe VARCHAR(255) DEFAULT NULL, recipe_info VARCHAR(1000) DEFAULT NULL, site VARCHAR(255) DEFAULT NULL, preview_image VARCHAR(255) DEFAULT NULL, detail_image VARCHAR(255) DEFAULT NULL, how_to_find VARCHAR(1000) DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_AD837724714819A0 ON restaurants (type_id_id)');
        $this->addSql('CREATE INDEX IDX_AD83772445EC589B ON restaurants (settlement_id_id)');
        $this->addSql('COMMENT ON COLUMN restaurants.create_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('COMMENT ON COLUMN restaurants.coordinates IS \'(DC2Type:array)\'');
        $this->addSql('CREATE TABLE restaurants_kitchens (restaurants_id INT NOT NULL, kitchens_id INT NOT NULL, PRIMARY KEY(restaurants_id, kitchens_id))');
        $this->addSql('CREATE INDEX IDX_716464694DCA160A ON restaurants_kitchens (restaurants_id)');
        $this->addSql('CREATE INDEX IDX_71646469E043FCBC ON restaurants_kitchens (kitchens_id)');
        $this->addSql('CREATE TABLE settlements (id INT NOT NULL, uuid UUID NOT NULL, name VARCHAR(255) NOT NULL, code VARCHAR(255) NOT NULL, coordinates TEXT NOT NULL, create_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, update_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, PRIMARY KEY(id))');
        $this->addSql('COMMENT ON COLUMN settlements.coordinates IS \'(DC2Type:array)\'');
        $this->addSql('COMMENT ON COLUMN settlements.create_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('CREATE TABLE tags (id INT NOT NULL, name VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE TABLE tags_restaurants (tags_id INT NOT NULL, restaurants_id INT NOT NULL, PRIMARY KEY(tags_id, restaurants_id))');
        $this->addSql('CREATE INDEX IDX_7AEC1CD68D7B4FB4 ON tags_restaurants (tags_id)');
        $this->addSql('CREATE INDEX IDX_7AEC1CD64DCA160A ON tags_restaurants (restaurants_id)');
        $this->addSql('CREATE TABLE users (id INT NOT NULL, uuid UUID NOT NULL, name VARCHAR(255) NOT NULL, is_male BOOLEAN NOT NULL, birth_day TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, �ф�address VARCHAR(255) NOT NULL, surname VARCHAR(255) NOT NULL, phone_number VARCHAR(255) DEFAULT NULL, email VARCHAR(255) DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('COMMENT ON COLUMN users.birth_day IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('CREATE TABLE messenger_messages (id BIGSERIAL NOT NULL, body TEXT NOT NULL, headers TEXT NOT NULL, queue_name VARCHAR(190) NOT NULL, created_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, available_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, delivered_at TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_75EA56E0FB7336F0 ON messenger_messages (queue_name)');
        $this->addSql('CREATE INDEX IDX_75EA56E0E3BD61CE ON messenger_messages (available_at)');
        $this->addSql('CREATE INDEX IDX_75EA56E016BA31DB ON messenger_messages (delivered_at)');
        $this->addSql('COMMENT ON COLUMN messenger_messages.created_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('COMMENT ON COLUMN messenger_messages.available_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('COMMENT ON COLUMN messenger_messages.delivered_at IS \'(DC2Type:datetime_immutable)\'');
        $this->addSql('CREATE OR REPLACE FUNCTION notify_messenger_messages() RETURNS TRIGGER AS $$
            BEGIN
                PERFORM pg_notify(\'messenger_messages\', NEW.queue_name::text);
                RETURN NEW;
            END;
        $$ LANGUAGE plpgsql;');
        $this->addSql('DROP TRIGGER IF EXISTS notify_trigger ON messenger_messages;');
        $this->addSql('CREATE TRIGGER notify_trigger AFTER INSERT OR UPDATE ON messenger_messages FOR EACH ROW EXECUTE PROCEDURE notify_messenger_messages();');
        $this->addSql('ALTER TABLE address ADD CONSTRAINT FK_D4E6F8135592D86 FOREIGN KEY (restaurant_id_id) REFERENCES restaurants (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE email ADD CONSTRAINT FK_E7927C7435592D86 FOREIGN KEY (restaurant_id_id) REFERENCES restaurants (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE news ADD CONSTRAINT FK_1DD39950714819A0 FOREIGN KEY (type_id_id) REFERENCES news_type (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE news_comments ADD CONSTRAINT FK_16A0357B5FB1909 FOREIGN KEY (news_id_id) REFERENCES news (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE news_comments ADD CONSTRAINT FK_16A0357BCEB712DF FOREIGN KEY (moderator_id_id) REFERENCES users (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE news_comments ADD CONSTRAINT FK_16A0357B9D86650F FOREIGN KEY (user_id_id) REFERENCES users (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE phone ADD CONSTRAINT FK_444F97DD35592D86 FOREIGN KEY (restaurant_id_id) REFERENCES restaurants (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE restaurants ADD CONSTRAINT FK_AD837724714819A0 FOREIGN KEY (type_id_id) REFERENCES restauran_types (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE restaurants ADD CONSTRAINT FK_AD83772445EC589B FOREIGN KEY (settlement_id_id) REFERENCES settlements (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE restaurants_kitchens ADD CONSTRAINT FK_716464694DCA160A FOREIGN KEY (restaurants_id) REFERENCES restaurants (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE restaurants_kitchens ADD CONSTRAINT FK_71646469E043FCBC FOREIGN KEY (kitchens_id) REFERENCES kitchens (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE tags_restaurants ADD CONSTRAINT FK_7AEC1CD68D7B4FB4 FOREIGN KEY (tags_id) REFERENCES tags (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE tags_restaurants ADD CONSTRAINT FK_7AEC1CD64DCA160A FOREIGN KEY (restaurants_id) REFERENCES restaurants (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
    }

    public function down(Schema $schema): void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->addSql('CREATE SCHEMA public');
        $this->addSql('DROP SEQUENCE address_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE email_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE kitchens_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE news_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE news_categories_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE news_comments_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE news_type_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE phone_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE restauran_types_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE restaurants_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE settlements_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE tags_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE users_id_seq CASCADE');
        $this->addSql('ALTER TABLE address DROP CONSTRAINT FK_D4E6F8135592D86');
        $this->addSql('ALTER TABLE email DROP CONSTRAINT FK_E7927C7435592D86');
        $this->addSql('ALTER TABLE news DROP CONSTRAINT FK_1DD39950714819A0');
        $this->addSql('ALTER TABLE news_comments DROP CONSTRAINT FK_16A0357B5FB1909');
        $this->addSql('ALTER TABLE news_comments DROP CONSTRAINT FK_16A0357BCEB712DF');
        $this->addSql('ALTER TABLE news_comments DROP CONSTRAINT FK_16A0357B9D86650F');
        $this->addSql('ALTER TABLE phone DROP CONSTRAINT FK_444F97DD35592D86');
        $this->addSql('ALTER TABLE restaurants DROP CONSTRAINT FK_AD837724714819A0');
        $this->addSql('ALTER TABLE restaurants DROP CONSTRAINT FK_AD83772445EC589B');
        $this->addSql('ALTER TABLE restaurants_kitchens DROP CONSTRAINT FK_716464694DCA160A');
        $this->addSql('ALTER TABLE restaurants_kitchens DROP CONSTRAINT FK_71646469E043FCBC');
        $this->addSql('ALTER TABLE tags_restaurants DROP CONSTRAINT FK_7AEC1CD68D7B4FB4');
        $this->addSql('ALTER TABLE tags_restaurants DROP CONSTRAINT FK_7AEC1CD64DCA160A');
        $this->addSql('DROP TABLE address');
        $this->addSql('DROP TABLE email');
        $this->addSql('DROP TABLE kitchens');
        $this->addSql('DROP TABLE news');
        $this->addSql('DROP TABLE news_categories');
        $this->addSql('DROP TABLE news_comments');
        $this->addSql('DROP TABLE news_type');
        $this->addSql('DROP TABLE phone');
        $this->addSql('DROP TABLE restauran_types');
        $this->addSql('DROP TABLE restaurants');
        $this->addSql('DROP TABLE restaurants_kitchens');
        $this->addSql('DROP TABLE settlements');
        $this->addSql('DROP TABLE tags');
        $this->addSql('DROP TABLE tags_restaurants');
        $this->addSql('DROP TABLE users');
        $this->addSql('DROP TABLE messenger_messages');
    }
}
