<?php

namespace App\Actions;

use App\Entity\InterfaceDataEntity;

class SortPriceAction implements InterfaceAction
{
    /**
     * Выполняет сортировку массива по убыванию цены
     * @param InterfaceDataEntity $model
     * @return array отсортированный
     */
    public function act(InterfaceDataEntity $model): array
    {
        $array = $model->prices;

        $priceColumn = array_column($array, "price");
        $countColumn = array_column($array, "count");

        array_multisort(
            $priceColumn,
            SORT_DESC,
            $countColumn,
            SORT_ASC,
            $array,
        );

        return $array;
    }
}
