<?php

namespace App\Actions;

class SortPriceAction
{
    /**
     * Выполняет сортировку массива по убыванию цены
     * @param array $array
     * @return array отсортированный
     */
    public function act(array $array): array
    {
        $priceColumn = array_column($array, "price");
        $countColumn = array_column($array, "count");

        array_multisort(
            $priceColumn,
            SORT_DESC,
            $countColumn,
            SORT_ASC,
            $array,
        );

        return $array;
    }
}
