<?php

namespace App\Requests;

use Symfony\Component\Validator\Constraints\All;
use Symfony\Component\Validator\Constraints\Collection;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\Constraints\Type;

class MenuRequest extends BaseRequest
{

    #[Type('array')]
    #[All(
        constraints: new Collection(fields:[
            'name' => [
                new NotBlank(),
                new Type('string'),
            ],
            'depth' => [
                new NotBlank(),
                new Type('integer'),
            ]
        ])
    )]
    public $menu;

    public function serialise(): mixed
    {
        return $this->menu;
    }
}
