<?php

namespace App\Controller;

use App\Actions\SortPriceAction;
use App\Requests\PricesRequest;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Attribute\Route;

class SortPriceController extends AbstractController
{
    /**
     * Контроллер волняет сортировку массива по убыванию цены используя sortPrice
     * @param PricesRequest $request
     * @param SortPriceAction $action
     * @return JsonResponse
     */
    #[Route('/sort/price', name: 'app_sort_price', methods: ['POST'])]
    public function index(PricesRequest $request, SortPriceAction $action): JsonResponse
    {
        return new JsonResponse($action->act($request->serialise()));
    }
}
