<?php

namespace App\Controller;

use App\Actions\ReadFileLineByLineAction;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

class ReadFileLineByLineController extends AbstractController
{
    /**
     * Принимает путь до файла,
     * проверяет, что файл существует и выводит пользователю построчный вывод используя yield
     *
     * @param string $filePath путь до файла
     * @return Response  */
    #[Route('/readbyline', name: 'app_read_file_line_by_line', methods: ['POST'])]
    public function index(
        Request $request,
        ReadFileLineByLineAction $action
    ) : Response {
        $file = $request->files->get('File');
        $content = "";
        try{
            foreach ($action->act($file->getRealPath()) as $line) {
                $content .= $line;
            }
        } catch (\Exception $exception) {
            return new Response($exception->getMessage(), Response::HTTP_NOT_FOUND);
        }

        return new Response($content);
    }
}
